# The reproducing codes for CarDEC on monocyte


This dataset was generated by our group, which can be downloaded from[GSE146974](https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE146974) or from [https://drive.google.com/file/d/1kR8Hhufoo2h2OtomW8n3kM0gaQhVS564/view?usp=sharing](https://drive.google.com/file/d/1kR8Hhufoo2h2OtomW8n3kM0gaQhVS564/view?usp=sharing). This dataset was generated from human peripheral blood mononuclear clear cells by Ficoll Separation followed by CD14 and CD16 positive cell selection. Since the CD14 and CD16 antibodies are not 100% specific, some T cells were also present in the scRNA-seq data. We performed clustering analysis using leiden’s algorithm for each batch and identified 288 T cells in total based on the T cell marker genes CD3D, CD3E and CD3G. Aftering removing these 288 T cells, there are 10,878 cells and 21,289 genes, which was processed and sequenced at three different days, resulting in three batches (3,640 cells in T1, 4,833 cells in T2 and 2,405 cells in T3) left in the remaining analysis. 

__***Human monocyte preparation***__: Monocyte preparation uses a modification of published protocols. Briefly, ~20 ml blood drawn in sodium heparin was processed immediately in the lab in the Clinical Research Center at Columbia University. PBMCs were isolated by gradient Ficoll paque centrifugation, which maintains cell viability and prevents ex vivo activation during cell recovery. Cells were stained with antibodies against human HLADR, CD14 and CD16 and monocyte subsets defined as HLADR+CD14++CD16-(classical), HLADR+CD14++CD16+ (intermediate), HLADR+CD14dim/CD16++ (nonclassical, patrolling monocyte). DAPI staining was used to exclude dead cells. Monocytes were sorted by a BD Influx Sorter into tubes for real-time 10x Genomics analysis.


## Run reproducing codes
The following five files gives how to run CarDEC and competing methods on monocyte dataset.

1. [CarDEC_monocyte.ipynb](./CarDEC_monocyte.ipynb) 
2. [dca+combat_monocyte.ipynb](dca+combat_monocyte.ipynb)
3. [MNN_monocyte.R](MNN_monocyte.R)
4. [scanorama_monocyte.ipynb](scanorama_monocyte.ipynb)
5. [scVI_monocyte.ipynb](scVI_monocyte.ipynb)

[TF_blood.xlsx](TF_blood.xlsx) or [TF_blood.txt](TF_blood.txt): we obtained TFs related to monocytes from Figure 4 in [Gene expression profiling reveals the defining features of the classical, intermediate, and nonclassical human monocyte subsets](https://ashpublications.org/blood/article/118/5/e16/29016/Gene-expression-profiling-reveals-the-defining).

The Rmarkdown file [CarDEC_monocyte_final.Rmd](CarDEC_monocyte_final.Rmd) is the reproducing codes for Figure 5 and all figures relatd to monocyte in our manuscript. Also we attached the corresponding html file [CarDEC_monocyte_final.nb.html](CarDEC_monocyte_final.nb.html), which includes figures.

The Rmarkdown file [CarDEC_monocyte_Figure6.Rmd](./CarDEC_monocyte_Figure6.Rmd) is the reproducing codes for Figure 6 in our manuscript. Also we attached the corresponding html file [CarDEC_monocyte_Figure6.nb.html](CarDEC_monocyte_Figure6.nb.html), which includes figures. 







